/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: SingletonMacros.h,v 1.2 1999/09/17 04:20:45 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_SingletonMacros_h	// [
#define Included_SingletonMacros_h

#include "pgpClassesConfig.h"

_PGP_BEGIN

// Macros for declaring singleton variables and functions

#define DECLARE_SINGLETON_VARIABLE(type)								\
	protected:															\
		static type	*mInstance;											\
																		\
	public:																\
		static type&	Instance();

#define DECLARE_SINGLETON_NEWDELFUNCS()									\
	public:																\
		static SMART_ERROR	CreateInstance();							\
		static void			DestroyInstance();


// Macros for defining singleton variables and functions

#define DEFINE_SINGLETON_VARIABLE(type)									\
	type	*type::mInstance	= NULL;									\
																		\
	type&																\
	type::Instance()													\
	{																	\
		return *mInstance;												\
	}

#if PGP_EXCEPTIONS

#define DEFINE_SINGLETON_NEWDELFUNCS(type)								\
	void																\
	type::CreateInstance()												\
	{																	\
		if (IsNull(mInstance))											\
			mInstance = new type;										\
	}																	\
																		\
	void																\
	type::DestroyInstance()												\
	{																	\
		if (IsntNull(mInstance))										\
		{																\
			pgpAssertAddrValid(mInstance, type);						\
																		\
			delete mInstance;											\
			mInstance = NULL;											\
		}																\
	}

#else	// !PGP_EXCEPTIONS

#define DEFINE_SINGLETON_NEWDELFUNCS(type)								\
	CComboError															\
	type::CreateInstance()												\
	{																	\
		CComboError	error;												\
																		\
		if (IsNull(mInstance))											\
		{																\
			if (IsNull(mInstance = new type))							\
				error.pgpErr = kPGPError_OutOfMemory;					\
																		\
			if (error.IsntError())										\
			{															\
				error = mInstance->Status();							\
																		\
				if (error.IsError())									\
				{														\
					delete mInstance;									\
					mInstance = NULL;									\
				}														\
			}															\
		}																\
																		\
		return error;													\
	}																	\
																		\
	void																\
	type::DestroyInstance()												\
	{																	\
		if (IsntNull(mInstance))										\
		{																\
			pgpAssertAddrValid(mInstance, type);						\
																		\
			delete mInstance;											\
			mInstance = NULL;											\
		}																\
	}

#endif	// PGP_EXCEPTIONS

_PGP_END

#endif	// Included_SingletonMacros_h
